﻿$(document).ready(function () {
    var ie7 = (navigator.appVersion.indexOf("MSIE 7.") != -1);

    $(".imageSelector .choiceList, .zoomedChoiceImage .zoomedImage").disableSelection();

    var toggleChoices = function (choice) {
        var container = choice.closest(".questionBackground");
        var checkBox = $(":checkbox", choice);
        var tableCell = choice.closest(".gridItem");
        var maxAnswers;

        if (tableCell.length > 0) {
            var columnPosition = tableCell.attr("data-column-position");
            maxAnswers = $(".gridColumnHeader[data-column-position='" + columnPosition + "']", container).attr("data-maxanswers");
        }
        else {
            var choiceList = choice.closest(".choiceList");
            maxAnswers = choiceList.attr("data-maxanswers");
        }

        $(".choice", choiceList).each(function () {
            $(this).removeClass("disabled");
        });

        var selectedCheckBoxes = $('.choiceImage.selectedImageChoice :checkbox[name=' + checkBox.attr('name') + ']', container);
        var choicesToDisable;

        if (selectedCheckBoxes.length > 0) {
            var isExclusive = checkBox.is("[data-exclusive=true]");

            if (isExclusive || maxAnswers == 1) {
                choicesToDisable = $('.choiceImage :checkbox[name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']', container);
            }
            else if (maxAnswers != null && maxAnswers > 1 && selectedCheckBoxes.length >= maxAnswers) {
                choicesToDisable = $('.choiceImage:not(.selectedImageChoice) :checkbox[name=' + checkBox.attr('name') + ']', container);
            }
            else {
                choicesToDisable = $('.choiceImage :checkbox[data-exclusive=true][name=' + checkBox.attr('name') + '][value!=' + checkBox.val() + ']', container)
            }
        }

        if (choicesToDisable) {
            choicesToDisable.each(function () {
                $(this).prop("checked", false);
                $(this).closest(".choiceImage").removeClass("selectedImageChoice");

                if (maxAnswers > 1) {
                    $(this).closest(".choice").toggleClass("disabled", true);
                }

                toggleOpenEnd($(this));
            });
        }
    };

    var handleImageChoiceClick = function (choice, zoomed, keycode) {
        var checkBox = $(":checkbox", choice);
        var choiceImage = $(".choiceImage", choice);

        var isChecked = !checkBox.is(":checked");

        checkBox.prop("checked", isChecked);

        choiceImage.toggleClass("selectedImageChoice", isChecked);

        if (!zoomed && keycode === undefined)
            choiceImage.toggleClass("highlightedImageChoice", !isChecked);

        if (isInGrid(choice)) {
            toggleGridOpenEnds(checkBox);
        } else {
            toggleOpenEnd(checkBox);
        }

        toggleChoices(choice);

        checkBox.trigger("change");
    };

    $(".imageSelector .choiceList").each(function () {
        var firstSelectedChoice = $(".choiceImage.selectedImageChoice", $(this)).first();

        if (firstSelectedChoice.length > 0) {
            toggleChoices(firstSelectedChoice.closest(".choice"));
        }

        if (ie7) {
            $(".choiceImage", $(this)).append();
        }
    });

    $(".imageChoice").on("click keyup", ".choice:not(.disabled) .choiceImage", function (e) {
        if (e.type == "click" || e.keyCode == "32") {
            var keycode = e.keyCode
            var choice = $(this).closest(".choice");
            handleImageChoiceClick(choice, undefined, keycode);
            e.stopPropagation();
        }
    });

    $(".imageChoice").on("mouseenter", ".choice:not(.disabled) .choiceImage", function (e) {
        var choiceImage = $(this);
        var choice = $(this).closest(".choice");
        var zoom = choice.attr("data-zoom");

        if (zoom != undefined && zoom != "" && zoom > 0 && !ie7) {
            var scale = Number(zoom) / 100 + 1;
            choice.css("transform", `scale(${scale})`);
        }
        if (!choiceImage.hasClass("selectedImageChoice")) {
            choiceImage.addClass("highlightedImageChoice");
        }

        e.stopPropagation();
    });

    $(".imageChoice").on("mouseleave", ".choice .choiceImage", function () {
        var choice = $(this).closest(".choice");
        choice.css("transform", `scale(1)`);
        $(this).removeClass("highlightedImageChoice");
    });
});